<?php

namespace UtillzCore\Inc\Src\Notification\Notifications;

class New_Comment extends \UtillzCore\Inc\Src\Notification\Base {

    public $user_can_manage = true;

    /*
     * general
     *
     */
    public function get_id() {
        return 'new-comment';
    }

    public function get_name() {
        return esc_html__('New comment has been received', 'utillz-core');
    }

    /*
     * email
     *
     */
    public function get_email_subject() {
        return esc_html__( 'New comment has been received', 'utillz-core' );
    }

    public function get_email_template() {
        return esc_html__( "Hello {user_display_name},\r\n\r\nYou have received a new comment.", 'utillz-core' );
    }

    /*
     * email admin
     *
     */
    public function get_email_admin_subject() {
        return esc_html__( 'New comment', 'utillz-core' );
    }

    public function get_email_admin_template() {
        return esc_html__( "Hello,\r\n\r\nA new comment has been sent", 'utillz-core' );
    }

    /*
     * site
     *
     */
    public function get_site_icon() {
        return [
            'set' => 'material-icons',
            'icon' => 'star',
        ];
    }

    public function get_site_message() {
        return esc_html__( 'New comment has been received', 'utillz-core' );
    }

    public function get_site_url() {
        if( isset( $this->meta['listing_id'] ) ) {
            return get_permalink( $this->meta['listing_id'] );
        }
        return null;
    }

}
